/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray.length == 0) {
            this.context = null;
        } else if (protectionDomainArray.length == 1) {
            this.context = protectionDomainArray[0] != null ? (ProtectionDomain[])protectionDomainArray.clone() : null;
        } else {
            ArrayList<ProtectionDomain> arrayList = new ArrayList<ProtectionDomain>(protectionDomainArray.length);
            for (int i = 0; i < protectionDomainArray.length; ++i) {
                if (protectionDomainArray[i] == null || arrayList.contains(protectionDomainArray[i])) continue;
                arrayList.add(protectionDomainArray[i]);
            }
            this.context = new ProtectionDomain[arrayList.size()];
            this.context = arrayList.toArray(this.context);
        }
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
        }
        this.context = accessControlContext.context;
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, DomainCombiner domainCombiner) {
        if (protectionDomainArray != null) {
            this.context = (ProtectionDomain[])protectionDomainArray.clone();
        }
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        this.context = protectionDomainArray;
        this.privilegedContext = accessControlContext;
        this.isPrivileged = true;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    DomainCombiner getAssignedCombiner() {
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        if (accessControlContext != null) {
            return accessControlContext.combiner;
        }
        return null;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n;
        boolean bl = false;
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            boolean bl2 = bl = !Debug.isOn("codebase=");
            if (!bl) {
                for (n = 0; this.context != null && n < this.context.length; ++n) {
                    if (this.context[n].getCodeSource() == null || this.context[n].getCodeSource().getLocation() == null || !Debug.isOn("codebase=" + this.context[n].getCodeSource().getLocation().toString())) continue;
                    bl = true;
                    break;
                }
            }
            if ((bl &= !Debug.isOn("permission=") || Debug.isOn("permission=" + permission.getClass().getCanonicalName())) && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (bl && Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    for (n = 0; n < this.context.length; ++n) {
                        debug.println("domain " + n + " " + this.context[n]);
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        for (n = 0; n < this.context.length; ++n) {
            if (this.context[n] == null || this.context[n].implies(permission)) continue;
            if (bl) {
                debug.println("access denied " + permission);
            }
            if (Debug.isOn("failure") && debug != null) {
                if (!bl) {
                    debug.println("access denied " + permission);
                }
                Thread.currentThread();
                Thread.dumpStack();
                final ProtectionDomain protectionDomain = this.context[n];
                final Debug debug = AccessControlContext.debug;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        debug.println("domain that failed " + protectionDomain);
                        return null;
                    }
                });
            }
            throw new AccessControlException("access denied " + permission, permission);
        }
        if (bl) {
            debug.println("access allowed " + permission);
        }
    }

    AccessControlContext optimize() {
        boolean bl;
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        boolean bl2 = this.context == null;
        boolean bl3 = bl = accessControlContext == null || accessControlContext.context == null;
        if (accessControlContext != null && accessControlContext.combiner != null) {
            return this.goCombiner(this.context, accessControlContext);
        }
        if (bl && bl2) {
            return this;
        }
        if (bl2) {
            return accessControlContext;
        }
        int n = this.context.length;
        if (bl && n <= 2) {
            return this;
        }
        if (n == 1 && this.context[0] == accessControlContext.context[0]) {
            return accessControlContext;
        }
        int n2 = bl ? 0 : accessControlContext.context.length;
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n + n2];
        if (!bl) {
            System.arraycopy(accessControlContext.context, 0, protectionDomainArray, 0, n2);
        }
        block0: for (int i = 0; i < this.context.length; ++i) {
            ProtectionDomain protectionDomain = this.context[i];
            if (protectionDomain == null) continue;
            for (int j = 0; j < n2; ++j) {
                if (protectionDomain == protectionDomainArray[j]) continue block0;
            }
            protectionDomainArray[n2++] = protectionDomain;
        }
        if (n2 != protectionDomainArray.length) {
            if (!bl && n2 == accessControlContext.context.length) {
                return accessControlContext;
            }
            if (bl && n2 == n) {
                return this;
            }
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n2];
            System.arraycopy(protectionDomainArray, 0, protectionDomainArray2, 0, n2);
            protectionDomainArray = protectionDomainArray2;
        }
        this.context = protectionDomainArray;
        this.combiner = null;
        this.isPrivileged = false;
        return this;
    }

    private AccessControlContext goCombiner(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        if (AccessControlContext.getDebug() != null) {
            debug.println("AccessControlContext invoking the Combiner");
        }
        ProtectionDomain[] protectionDomainArray2 = accessControlContext.combiner.combine(protectionDomainArray, accessControlContext.context);
        this.context = protectionDomainArray2;
        this.combiner = accessControlContext.combiner;
        this.isPrivileged = false;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (this.context == null) {
            return accessControlContext.context == null;
        }
        if (accessControlContext.context == null) {
            return false;
        }
        if (!this.containsAllPDs(accessControlContext) || !accessControlContext.containsAllPDs(this)) {
            return false;
        }
        if (this.combiner == null) {
            return accessControlContext.combiner == null;
        }
        if (accessControlContext.combiner == null) {
            return false;
        }
        return this.combiner.equals(accessControlContext.combiner);
    }

    private boolean containsAllPDs(AccessControlContext accessControlContext) {
        boolean bl = false;
        for (int i = 0; i < this.context.length; ++i) {
            bl = false;
            ProtectionDomain protectionDomain = this.context[i];
            if (protectionDomain == null) {
                for (int j = 0; j < accessControlContext.context.length && !bl; ++j) {
                    bl = accessControlContext.context[j] == null;
                }
            } else {
                Class<?> clazz = protectionDomain.getClass();
                for (int j = 0; j < accessControlContext.context.length && !bl; ++j) {
                    ProtectionDomain protectionDomain2 = accessControlContext.context[j];
                    bl = protectionDomain2 != null && clazz == protectionDomain2.getClass() && protectionDomain.equals(protectionDomain2);
                }
            }
            if (bl) continue;
            return false;
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.context == null) {
            return n;
        }
        for (int i = 0; i < this.context.length; ++i) {
            if (this.context[i] == null) continue;
            n ^= this.context[i].hashCode();
        }
        return n;
    }

    static {
        SharedSecrets.setJavaSecurityAccess(new JavaSecurityAccess(){

            @Override
            public <T> T doIntersectionPrivilege(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext, AccessControlContext accessControlContext2) {
                if (privilegedAction == null) {
                    throw new NullPointerException();
                }
                return AccessController.doPrivileged(privilegedAction, new AccessControlContext(accessControlContext.getContext(), accessControlContext2).optimize());
            }

            @Override
            public <T> T doIntersectionPrivilege(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext) {
                return this.doIntersectionPrivilege(privilegedAction, AccessController.getContext(), accessControlContext);
            }
        });
    }
}

