Qualcomm Snapdragon partition backup/restore tool set
======================================================================

Created by: Eugene Muzychenko (software@muzychenko.net)

Version: 1.1





Caution
======================================================================

Not for beginners! You must clearly understand what you are doing.

Improper usage may damage your device.

Use it at your own risk.

I take no resposibility for any malfunction.





Purpose
======================================================================

This tool set simplifies partition backup/restore on Qualcomm
Snapdragon devices supporting Sahara protocol (serial interface with
VID_05C6&PID_9008).

Initially created and tested on Xiaomi Redmi Note 3 Pro (Snapdragon
650, MSM8952/MSM8956) with both locked and unlocked bootloader.

Selected partition list includes non-volatile, non-zero partitions
containing individual device parameters (IMEI, MAC addresses,
calibration values etc.).

Device's eMMC access is gained by the "emmcdl" utility.

Tool set consists of several Windows command files:

getparttable - reads partition table from the device and writes it to a
file.

readselparts - reads selected partitions from the device and saves them
to .img files.

makerawprog - creates XML Raw Program script in Qualcomm format.

writeselparts - writes image files described by Raw Program to the
device.

params - sets working parameters, called indirectly.





Usage
======================================================================

Charge device battery.

Connect device to USB port and boot it in Emergency Download mode
(9008/EDL). A serial (COM) port should appear in Device Manager.

Check/edit "params.cmd" file. You should set the following parameters:

SaharaComPort - device interface port (for example, com11).

FirehoseFile - full path to the "Firehose" interface file. For Xiaomi
devices, this file is included in "fastboot" firmware package. For some
other devices, this file is not provided by a vendor and should be
obtained somewhere.



Execute "getparttable" command file. It will read partition table from
the device and save it to "parttable.txt" file.



Check/edit "selparts.txt" file containing a list of partitions to read
from or write to the device. By default, Xiaomi Redmi Note 3 Pro
non-volatile partition list is provided. If you don't know which
partitions to backup, put to this list all partitions that are not
flashed by vendor's flashing script (flash_all.bat, rawprogram0.xml
etc.).



Execute "readselparts.cmd". It will read partitions in accordance with
the list and save them to .img files. Now you can copy them to a safe
place together with partition table file.



To restore selected partitions, execute "makerawprog.cmd". It will
create an XML Raw Program script in Qualcomm format (named
rawprogram0.xml by default).

Now you can restore selected partitions two ways:

- By using MiFlash or a Qualcomm utility (for example, from QPST).

- By executing "writeselparts.cmd" - via emmcdl utility. This way is
simpler but more dangerous because emmcdl sometimes loses device
connection.

For MiFlash or Qualcomm tools, an empty patch script (patch0.xml), is
included.





Error handling
======================================================================

Sometimes, emmcdl loses device connection and exits with an error. In
such case, reboot the device in 9008/EDL mode and try again.





Credits
======================================================================

emmcdl.exe can be found here:

http://forum.xda-developers.com/attachment.php?attachmentid=3760575&d=1464071604


Another compiled binary can be found here:

http://github.com/kiddlu/android-host-knife
