#!/sbin/sh
mkdir /tmp/out;

dd if=/dev/block/bootdevice/by-name/boot of=/tmp/boot.img || exit 1
if [ -z /tmp/boot.img ]; then exit 1; fi

/tmp/unpackbootimg -i /tmp/boot.img -o /tmp/out

if [ -e /tmp/out/boot.img-ramdisk.gz ]; then
	ramdisk=/tmp/out/boot.img-ramdisk.gz
else
	exit 1
fi

mkdir -p /tmp/out/ramdisk;
cd /tmp/out/ramdisk;
gunzip -c $ramdisk | cpio -i;
chmod -R 755 /tmp/out/ramdisk;

replace_line() {
  if [ ! -z "$(grep "$2" $1)" ]; then
    line=`grep -n "$2" $1 | head -n1 | cut -d: -f1`;
    sed -i "${line}s;.*;${3};" $1;
  fi;
}

replace_line init.target.rc "setprop persist.camera.HAL3.enabled 1" "    setprop persist.camera.HAL3.enabled 0";

find . | cpio -H newc -o | gzip > /tmp/out/ramdisk-new.cpio.gz;

cmdline="$(cat /tmp/out/boot.img-cmdline)"

/tmp/mkbootimg --kernel /tmp/out/boot.img-zImage --ramdisk /tmp/out/ramdisk-new.cpio.gz --cmdline "$cmdline" --base 0x80000000 --kernel_offset 0x00008000 --pagesize 4096 --ramdisk_offset 0x01000000 --tags_offset 0x00000100 --output /tmp/newboot.img

if [ -z /tmp/newboot.img ]; then exit 1; fi

dd if=/tmp/newboot.img of=/dev/block/bootdevice/by-name/boot

rm /data/property/persist.camera.HAL3.enabled;

exit 0
